/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import music.Main;
import music.commonUtils;
import music.musicScore;
import music.popupCanvas;
import music.settings;

public class gameCanvas
extends Canvas {
    private static final long serialVersionUID = 200L;
    private musicScore score = null;
    public static boolean useSharps;
    public static final int clefStart = 15;
    public static final int clefWidth = 75;
    public static final int staffStart = 90;
    protected static int gameScore;
    private static int combo;
    protected static int maxCombo;
    private static int instTranspose;
    private static final int border = 15;
    private static final int scoreFromRight = 300;
    private static final int staffThickness = 2;
    private static final int ledger_border = 8;
    private static final int ledger_height = 2;
    private static final int noteWidth = 10;
    private static final int accidental_height = 2;
    public static int distanceAroundScore;
    private int oldHeight = 0;
    private int oldWidth = 0;
    private int cHeight = 0;
    private int cWidth = 0;
    private boolean firstPaint = true;
    private boolean need_ledger = false;
    private boolean lower_ledger = false;
    private boolean accidental_sharp;
    private boolean accidental_flat;
    private Image rightOffscreen;
    private Image leftOffscreen;
    private Graphics bufferGraphicsR;
    private Graphics bufferGraphicsL;
    protected static final int scorePosition = -120;
    private Color restColor = new Color(255, 94, 166);
    private static int pixelsPerFrame;
    private static int framesPerSecond;
    private static double timeMultiplier;
    private static int currentBPM;
    private long time = System.currentTimeMillis();

    public gameCanvas(int instrumentTranspose, musicScore toPlay) {
        this.score = toPlay;
        instTranspose = instrumentTranspose;
        this.score.currentBPM = this.score.BPMarray[0];
        gameCanvas.changeBPM(this.score.currentBPM);
        this.score.BPMarrayBeatToPixValues();
    }

    public static void changeTimeMultiplier(double multiple) {
        timeMultiplier *= multiple;
        gameCanvas.calculateFrameRate();
    }

    public static void changeBPM(int bpm) {
        currentBPM = bpm;
        gameCanvas.calculateFrameRate();
    }

    private static void calculateFrameRate() {
        for (pixelsPerFrame = 1; pixelsPerFrame <= 3 && (framesPerSecond = (int)((double)settings.PPB * timeMultiplier * (double)currentBPM / 60.0 / (double)pixelsPerFrame)) >= 1000; ++pixelsPerFrame) {
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        int beatPosition = 1;
        int numBeats = this.getWidth() / settings.PPB + 1;
        int[] beatLine = new int[numBeats];
        this.cHeight = this.getHeight();
        this.cWidth = this.getWidth();
        int x_dif = Main.f.getWidth() - this.cWidth;
        int y_dif = Main.f.getHeight() - this.cHeight;
        if (this.firstPaint) {
            this.requestFocus();
            this.rightOffscreen = this.createImage(this.getWidth() - 90, this.getHeight());
            this.bufferGraphicsR = this.rightOffscreen.getGraphics();
            this.leftOffscreen = this.createImage(90, this.getHeight());
            this.bufferGraphicsL = this.leftOffscreen.getGraphics();
            this.oldHeight = this.getHeight();
            this.oldWidth = this.getWidth();
            distanceAroundScore = this.oldHeight / 3;
            this.firstPaint = false;
        }
        this.bufferGraphicsL.setColor(Color.white);
        this.bufferGraphicsL.fillRect(0, 0, 90, this.oldHeight);
        if (popupCanvas.isImageLoaded) {
            this.bufferGraphicsL.drawImage(popupCanvas.clefImage, 15, distanceAroundScore, 90, this.getHeight() - distanceAroundScore, 0, 0, popupCanvas.clefImage.getWidth(), popupCanvas.clefImage.getHeight(), null);
        }
        if (beatPosition > 0) {
            for (int beatLineCt = numBeats - 1; beatLineCt >= 0; --beatLineCt) {
                beatLine[beatLineCt] = beatPosition = x_dif + this.cWidth - beatLineCt * settings.PPB;
            }
        }
        for (int beatCount = settings.PPB - 1; beatCount >= 0; beatCount -= pixelsPerFrame) {
            block61: {
                if (Main.dopause) {
                    return;
                }
                this.bufferGraphicsR.setColor(Color.black);
                for (int count = 4; count >= 0; --count) {
                    this.bufferGraphicsR.fillRect(0, distanceAroundScore + count * (this.cHeight - 2 * distanceAroundScore) / 4, this.cWidth - 90, 2);
                }
                this.bufferGraphicsR.setColor(Color.white);
                for (int bb = numBeats - 1; bb >= 0; --bb) {
                    if (beatLine[bb] < 0) continue;
                    int n = bb;
                    int n2 = beatLine[n];
                    beatLine[n] = n2 - 1;
                    this.bufferGraphicsR.drawLine(beatLine[bb], 15, n2, this.cHeight - 15);
                }
                for (int kk = 0; kk < this.score.displayScore.length - 1; ++kk) {
                    this.accidental_sharp = false;
                    this.accidental_flat = false;
                    this.need_ledger = false;
                    this.lower_ledger = false;
                    int noteLength = this.score.countScore[kk + 1] - commonUtils.max(this.score.countScore[kk], 0);
                    int noteLocation = -1;
                    if (noteLength < 0 || this.score.countScore[kk] >= this.cWidth - 90 || this.score.displayScore[kk].equals("")) continue;
                    String storedNote = this.score.displayScore[kk];
                    switch (storedNote.charAt(0)) {
                        case 'G': {
                            if (storedNote.endsWith("4")) {
                                noteLocation = distanceAroundScore - (this.cHeight - 2 * distanceAroundScore) / 8;
                                break;
                            }
                            if (storedNote.endsWith("2")) {
                                noteLocation = distanceAroundScore + 13 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            noteLocation = distanceAroundScore + 3 * (this.cHeight - 2 * distanceAroundScore) / 4;
                            break;
                        }
                        case 'F': {
                            if (storedNote.endsWith("5")) {
                                noteLocation = distanceAroundScore - 7 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("4")) {
                                noteLocation = distanceAroundScore;
                                break;
                            }
                            if (storedNote.endsWith("2")) {
                                noteLocation = distanceAroundScore + 7 * (this.cHeight - 2 * distanceAroundScore) / 4;
                                this.need_ledger = true;
                                break;
                            }
                            noteLocation = distanceAroundScore + 7 * (this.cHeight - 2 * distanceAroundScore) / 8;
                            break;
                        }
                        case 'E': {
                            if (storedNote.endsWith("5")) {
                                noteLocation = distanceAroundScore - 3 * (this.cHeight - 2 * distanceAroundScore) / 4;
                                this.need_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("4")) {
                                noteLocation = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 8;
                                break;
                            }
                            if (storedNote.endsWith("2")) {
                                noteLocation = distanceAroundScore + 15 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            noteLocation = this.cHeight - distanceAroundScore;
                            break;
                        }
                        case 'D': {
                            if (storedNote.endsWith("5")) {
                                noteLocation = distanceAroundScore - 5 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("3")) {
                                noteLocation = distanceAroundScore + 9 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                break;
                            }
                            noteLocation = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 4;
                            break;
                        }
                        case 'C': {
                            if (storedNote.endsWith("5")) {
                                noteLocation = distanceAroundScore - (this.cHeight - 2 * distanceAroundScore) / 2;
                                this.need_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("3")) {
                                noteLocation = distanceAroundScore + 5 * (this.cHeight - 2 * distanceAroundScore) / 4;
                                this.need_ledger = true;
                                break;
                            }
                            noteLocation = distanceAroundScore + 3 * (this.cHeight - 2 * distanceAroundScore) / 8;
                            break;
                        }
                        case 'B': {
                            if (storedNote.endsWith("4")) {
                                noteLocation = distanceAroundScore - 3 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("2")) {
                                noteLocation = distanceAroundScore + 11 * (this.cHeight - 2 * distanceAroundScore) / 8;
                                this.need_ledger = true;
                                this.lower_ledger = true;
                                break;
                            }
                            noteLocation = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 2;
                            break;
                        }
                        case 'A': {
                            if (storedNote.endsWith("4")) {
                                noteLocation = distanceAroundScore - (this.cHeight - 2 * distanceAroundScore) / 4;
                                this.need_ledger = true;
                                break;
                            }
                            if (storedNote.endsWith("2")) {
                                noteLocation = distanceAroundScore + 6 * (this.cHeight - 2 * distanceAroundScore) / 4;
                                this.need_ledger = true;
                                break;
                            }
                            noteLocation = distanceAroundScore + 5 * (this.cHeight - 2 * distanceAroundScore) / 8;
                        }
                    }
                    if (storedNote.length() == 3) {
                        if (storedNote.charAt(storedNote.length() - 2) == '#') {
                            this.accidental_sharp = true;
                        } else if (storedNote.charAt(storedNote.length() - 2) == 'b') {
                            this.accidental_flat = true;
                        }
                    }
                    int toDraw = commonUtils.max(this.score.countScore[kk], 0);
                    if (this.need_ledger) {
                        if (!this.lower_ledger) {
                            this.drawLedger(toDraw, noteLocation, noteLength);
                        } else if (noteLocation < this.cHeight / 2) {
                            this.drawLedger(toDraw, noteLocation + (this.cHeight - 2 * distanceAroundScore) / 8, noteLength);
                        } else {
                            this.drawLedger(toDraw, noteLocation - (this.cHeight - 2 * distanceAroundScore) / 8, noteLength);
                        }
                    }
                    int curvature = 3;
                    if (this.score.countScore[kk] >= 0) {
                        this.bufferGraphicsR.setColor(Color.black);
                        this.bufferGraphicsR.fillOval(toDraw, noteLocation - 5 - 1, 11, 11);
                        this.bufferGraphicsR.setColor(this.noteToColor(storedNote));
                        this.bufferGraphicsR.fillOval(toDraw + curvature - 1, noteLocation - 5 - 1, 11, 11);
                        this.bufferGraphicsR.setColor(this.noteToColor(storedNote));
                        this.bufferGraphicsR.fillRect(toDraw + curvature + 10, noteLocation - 5, noteLength - 10 - curvature, 10);
                    } else {
                        this.bufferGraphicsR.setColor(this.noteToColor(storedNote));
                        this.bufferGraphicsR.fillRect(toDraw, noteLocation - 5, noteLength, 10);
                        curvature = 0;
                    }
                    this.bufferGraphicsR.setColor(Color.white);
                    this.bufferGraphicsR.drawLine(toDraw + noteLength, noteLocation - 5, toDraw + noteLength, noteLocation + 5);
                    if (this.accidental_flat) {
                        this.bufferGraphicsR.setColor(Color.black);
                        this.bufferGraphicsR.fillRect(toDraw + curvature, noteLocation + 5, noteLength - curvature, 2);
                        this.bufferGraphicsR.setColor(Color.white);
                        this.bufferGraphicsR.drawLine(toDraw + noteLength, noteLocation + 5, toDraw + noteLength, noteLocation + 5 + 2);
                        continue;
                    }
                    if (!this.accidental_sharp) continue;
                    this.bufferGraphicsR.setColor(Color.black);
                    this.bufferGraphicsR.fillRect(toDraw + curvature, noteLocation - 5, noteLength - curvature, 2);
                    this.bufferGraphicsR.setColor(Color.white);
                    this.bufferGraphicsR.drawLine(toDraw + noteLength, noteLocation - 5, toDraw + noteLength, noteLocation - 5 - 2);
                }
                if (this.score.BPMarray.length != 1) {
                    for (int index = 2; index < this.score.BPMarray.length; index += 2) {
                        int n = index;
                        this.score.BPMarray[n] = this.score.BPMarray[n] - pixelsPerFrame;
                        if (this.score.BPMarray[index] > 0 || this.score.BPMarray[index] <= -pixelsPerFrame) continue;
                        this.score.currentBPM = this.score.BPMarray[index - 1];
                        gameCanvas.changeBPM(this.score.currentBPM);
                    }
                }
                this.bufferGraphicsR.setColor(Color.black);
                for (int cc = numBeats - 1; cc >= 0; --cc) {
                    if (beatLine[cc] <= 1) continue;
                    this.bufferGraphicsR.fillRect(beatLine[cc] - 1, distanceAroundScore, 2, this.cHeight - distanceAroundScore - distanceAroundScore);
                }
                for (int mm = this.score.concertScore.length - 1; mm >= 0; --mm) {
                    int n = mm;
                    this.score.countScore[n] = this.score.countScore[n] - pixelsPerFrame;
                    if (this.score.countScore[mm] == -120) {
                        if (Double.parseDouble(Main.userInput[1]) < settings.backgroundNoise) {
                            if (this.score.concertScore[mm].length() == 0) {
                                popupCanvas.setText("Good!");
                                popupCanvas.setColor(this.restColor);
                                gameScore += combo++ * 100;
                                if (combo <= maxCombo) continue;
                                maxCombo = combo;
                                continue;
                            }
                            if (instTranspose != 0) {
                                popupCanvas.setColor(this.noteToColor(this.intToNote((gameCanvas.notetoint(this.score.concertScore[mm]) + instTranspose) % 12)));
                            } else {
                                popupCanvas.setColor(this.noteToColor(this.score.concertScore[mm]));
                            }
                            popupCanvas.setText("Miss");
                            Main.userInput[0] = "";
                            combo = 1;
                            continue;
                        }
                        gameScore += combo * this.score(Main.userInput[0], this.score.concertScore[mm]);
                        continue;
                    }
                    if (this.score.countScore[mm] < -100) break;
                }
                if (Double.parseDouble(Main.userInput[1]) > settings.backgroundNoise) {
                    this.drawNotePlayed(Main.userInput[0]);
                } else {
                    this.drawNotePlayed("");
                }
                int wait = (int)(System.currentTimeMillis() - this.time);
                try {
                    long sleep = (long)(1000.0 / (double)framesPerSecond - (double)wait);
                    if (sleep < 1L) {
                        sleep = 1L;
                    }
                    Thread.sleep(sleep);
                }
                catch (Exception e) {
                    if (!Main.debugErrors) break block61;
                    System.out.println(e);
                }
            }
            this.time = System.currentTimeMillis();
            if (beatCount % 15 == 0) {
                Font curFont = this.getFont();
                this.bufferGraphicsR.setFont(new Font(curFont.getFontName(), curFont.getStyle(), 16));
                this.bufferGraphicsR.setColor(Color.white);
                this.bufferGraphicsR.fillRect(0, 0, this.cWidth - 90, 15);
                this.bufferGraphicsR.setColor(Color.black);
                this.bufferGraphicsR.drawString("BPM: " + Integer.toString((int)((double)this.score.currentBPM * timeMultiplier)) + "  Score: " + Integer.toString(gameScore) + "   Combo:" + Integer.toString(combo), this.cWidth - 90 - 300, 15);
                g.drawImage(this.leftOffscreen, 0, 0, this);
            }
            g.drawImage(this.rightOffscreen, 90, 0, this);
        }
    }

    private int score(String playedNote, String drawnNote) {
        int pN = gameCanvas.notetoint(playedNote);
        int dN = gameCanvas.notetoint(drawnNote);
        popupCanvas.setColor(this.noteToColor(this.intToNote((dN + instTranspose) % 12)));
        if (dN == -2) {
            popupCanvas.setColor(this.restColor);
            popupCanvas.setText("Miss!");
            Main.popup.repaint();
            combo = 1;
            return 0;
        }
        if (pN == dN) {
            popupCanvas.setText("Good!");
            Main.popup.repaint();
            if (++combo > maxCombo) {
                maxCombo = combo;
            }
            return 100;
        }
        if (pN == (dN + 1) % 12 || pN == (dN + 11) % 12) {
            popupCanvas.setText("OK!");
            Main.popup.repaint();
            return 50;
        }
        popupCanvas.setText("Miss!");
        Main.popup.repaint();
        combo = 1;
        return 0;
    }

    private void drawNotePlayed(String firstNote) {
        int draw_x = 0;
        int draw_y = 0;
        int width = 15;
        int height = 10;
        this.bufferGraphicsL.setColor(Color.white);
        this.bufferGraphicsL.fillRect(0, 0, 15, this.cHeight);
        if (!firstNote.equals("")) {
            firstNote = this.intToNote((gameCanvas.notetoint(firstNote) + instTranspose) % 12);
            this.bufferGraphicsL.setColor(this.noteToColor(firstNote));
            switch (firstNote.charAt(0)) {
                case 'E': {
                    draw_y = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 8;
                    break;
                }
                case 'D': {
                    draw_y = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 4;
                    break;
                }
                case 'C': {
                    draw_y = distanceAroundScore + 3 * (this.cHeight - 2 * distanceAroundScore) / 8;
                    break;
                }
                case 'B': {
                    draw_y = distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 2;
                    break;
                }
                case 'A': {
                    draw_y = distanceAroundScore + 5 * (this.cHeight - 2 * distanceAroundScore) / 8;
                    break;
                }
                case 'G': {
                    draw_y = distanceAroundScore + 3 * (this.cHeight - 2 * distanceAroundScore) / 4;
                    break;
                }
                case 'F': {
                    draw_y = distanceAroundScore + 7 * (this.cHeight - 2 * distanceAroundScore) / 8;
                    break;
                }
                case '?': {
                    draw_y = distanceAroundScore;
                }
            }
            this.bufferGraphicsL.fillRect(draw_x, draw_y, width, height);
            this.bufferGraphicsL.setColor(Color.black);
            this.bufferGraphicsL.drawString(firstNote, draw_x + 1, draw_y);
        }
    }

    public static int stringtoMidi(String note) {
        if (note.equals("_")) {
            return -1;
        }
        try {
            return gameCanvas.notetoint(note) + 57 + 12 * (Integer.parseInt(note.substring(note.length() - 1)) - 4);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (Main.debugErrors) {
                System.out.println(e);
            }
            return 0;
        }
    }

    private static int notetoint(String note) {
        int value = -2;
        if (note.length() > 1 && !note.endsWith("#") && !note.endsWith("b")) {
            note = note.substring(0, note.length() - 1);
        }
        if (note.equals("A")) {
            value = 0;
        } else if (note.equals("A#") || note.equals("Bb")) {
            value = 1;
        } else if (note.equals("B") || note.equals("Cb")) {
            value = 2;
        } else if (note.equals("B#") || note.equals("C")) {
            value = 3;
        } else if (note.equals("C#") || note.equals("Db")) {
            value = 4;
        } else if (note.equals("D")) {
            value = 5;
        } else if (note.equals("D#") || note.equals("Eb")) {
            value = 6;
        } else if (note.equals("E") || note.equals("Fb")) {
            value = 7;
        } else if (note.equals("E#") || note.equals("F")) {
            value = 8;
        } else if (note.equals("F#") || note.equals("Gb")) {
            value = 9;
        } else if (note.equals("G")) {
            value = 10;
        } else if (note.equals("G#") || note.equals("Ab")) {
            value = 11;
        }
        return value;
    }

    private String intToNote(int value) {
        switch (value) {
            case -2: {
                return "";
            }
            case 0: {
                return "A";
            }
            case 1: {
                if (useSharps) {
                    return "A#";
                }
                return "Bb";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 4: {
                if (useSharps) {
                    return "C#";
                }
                return "Db";
            }
            case 5: {
                return "D";
            }
            case 6: {
                if (useSharps) {
                    return "D#";
                }
                return "Eb";
            }
            case 7: {
                return "E";
            }
            case 8: {
                return "F";
            }
            case 9: {
                if (useSharps) {
                    return "F#";
                }
                return "Gb";
            }
            case 10: {
                return "G";
            }
            case 11: {
                if (useSharps) {
                    return "G#";
                }
                return "Ab";
            }
        }
        return "";
    }

    private void drawLedger(int ledgerLocation, int ledgerHeight, int noteLength) {
        this.bufferGraphicsR.setColor(Color.white);
        this.bufferGraphicsR.drawLine(ledgerLocation + noteLength + 8, ledgerHeight + 1, ledgerLocation + noteLength + 8, ledgerHeight - 1);
        this.bufferGraphicsR.setColor(Color.black);
        if (ledgerLocation > 8) {
            this.bufferGraphicsR.fillRect(ledgerLocation - 8, ledgerHeight - 1, noteLength + 16, 2);
        } else {
            this.bufferGraphicsR.fillRect(ledgerLocation, ledgerHeight - 1, noteLength, 2);
        }
        if (ledgerHeight < distanceAroundScore - (this.cHeight - 2 * distanceAroundScore) / 4) {
            this.drawLedger(ledgerLocation, ledgerHeight + (this.cHeight - 2 * distanceAroundScore) / 4, noteLength);
        } else if (ledgerHeight > this.cHeight - distanceAroundScore + (this.cHeight - 2 * distanceAroundScore) / 4) {
            this.drawLedger(ledgerLocation, ledgerHeight - (this.cHeight - 2 * distanceAroundScore) / 4, noteLength);
        }
    }

    private Color noteToColor(String note) {
        if (note.length() == 0) {
            return this.restColor;
        }
        switch (note.charAt(0)) {
            case 'G': {
                return Main.colors[2];
            }
            case 'F': {
                return Main.colors[1];
            }
            case 'E': {
                return Main.colors[0];
            }
            case 'D': {
                return Main.colors[6];
            }
            case 'C': {
                return Main.colors[5];
            }
            case 'B': {
                return Main.colors[4];
            }
            case 'A': {
                return Main.colors[3];
            }
        }
        return Color.gray;
    }

    protected void reset() {
        combo = 1;
        this.rightOffscreen = null;
        this.leftOffscreen = null;
        this.bufferGraphicsR = null;
        this.bufferGraphicsL = null;
        timeMultiplier = 1.0;
    }

    static {
        gameScore = 0;
        combo = 1;
        maxCombo = 1;
        distanceAroundScore = settings.screenHeight / 3;
        pixelsPerFrame = 1;
        framesPerSecond = 0;
        timeMultiplier = 1.0;
        currentBPM = 0;
    }
}

